﻿// -- FILE ------------------------------------------------------------------
// name       : RuntimeControlsAdapter.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Web.UI;
using Itenso.WebUserForms.Controls;

namespace Itenso.WebUserForms.Runtime
{

	// ------------------------------------------------------------------------
	public abstract class RuntimeControlsAdapter : UserFormVisitor
	{

		// ----------------------------------------------------------------------
		protected RuntimeControlsAdapter( Control startControl )
			: base( startControl )
		{
		} // RuntimeControlsAdapter

		// ----------------------------------------------------------------------
		public void Apply()
		{
			Start();
		} // Apply

		// ----------------------------------------------------------------------
		protected abstract Control GetRuntimeControl( Control placeholderControl );

		// ----------------------------------------------------------------------
		protected override void VisitFormField( Control control, IUserFormField formField, IUserFormHeader formHeader )
		{
			IPlaceholderControl placeholder = control as IPlaceholderControl;
			if ( placeholder == null )
			{
				return;
			}
			Control placeholderControl = placeholder.Control;
			if ( placeholderControl == null )
			{
				throw new InvalidOperationException( "placeholder control without control " + control );
			}

			Control parentControl = placeholderControl.Parent;
			if ( parentControl == null )
			{
				return; // parent required
			}
			int parentIndex = parentControl.Controls.IndexOf( placeholderControl );
			if ( parentIndex < 0 )
			{
				return; // invalid position in parents collection
			}

			Control runtimeControl = GetRuntimeControl( placeholderControl );
			if ( runtimeControl == null )
			{
				throw new InvalidOperationException( "missing replacement control for " + placeholderControl );
			}
			if ( runtimeControl is IPlaceholderControl )
			{
				throw new InvalidOperationException( "replacement control can't be a placeholder " + runtimeControl );
			}

			parentControl.Controls.AddAt( parentIndex, runtimeControl );
			parentControl.Controls.Remove( placeholderControl );
		} // VisitFormField

	} // class RuntimeControlsAdapter

} // namespace Itenso.WebUserForms.Runtime
// -- EOF -------------------------------------------------------------------
