﻿// -- FILE ------------------------------------------------------------------
// name       : LookupAdapter.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Web.UI;
using System.Web.UI.WebControls;
using Itenso.WebUserForms.Controls;
using Itenso.WebUserForms.Data.Lookup;

namespace Itenso.WebUserForms.Runtime
{
	using System.Collections.Generic;

	// ------------------------------------------------------------------------
	public static class LookupAdapter
	{

		// ----------------------------------------------------------------------
		public static void Apply( ILookupProvider lookupProvider, UserControl userForm )
		{
			if ( lookupProvider == null )
			{
				throw new ArgumentNullException( "lookupProvider" );
			}
			if ( userForm == null )
			{
				throw new ArgumentNullException( "userForm" );
			}

			LookupFieldCollector lookupFieldCollector = new LookupFieldCollector( userForm );
			lookupFieldCollector.Collect();
			foreach ( ILookupField lookupField in lookupFieldCollector.LookupFields )
			{
				lookupField.Items.Clear();

				ILookupValueCollection lookupValues = lookupProvider.GetLookup( lookupField.LookupName, null );
				if ( lookupValues == null )
				{
					continue;
				}

				Apply( lookupValues, lookupField );
			}

		} // Apply

		// ----------------------------------------------------------------------
		private static void Apply( IEnumerable<ILookupValue> lookupValues, ILookupField lookupField )
		{
			if ( lookupValues == null )
			{
				throw new ArgumentNullException( "lookupValues" );
			}
			if ( lookupField == null )
			{
				throw new ArgumentNullException( "lookupField" );
			}

			lookupField.Items.Clear();
			foreach ( ILookupValue lookupValue in lookupValues )
			{
				lookupField.Items.Add( new ListItem( lookupValue.Value.ToString(), lookupValue.Key ) );
			}

			if ( lookupField.Items.Count > 0 )
			{
				lookupField.Items[ 0 ].Selected = true;
			}
		} // Apply

	} // class LookupAdapter

} // namespace Itenso.WebUserForms.Runtime
// -- EOF -------------------------------------------------------------------
