﻿// -- FILE ------------------------------------------------------------------
// name       : ManageForms.aspx.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.IO;
using System.Configuration;
using System.Web.UI;
using System.Web.UI.WebControls;
using Itenso.WebUserForms.Controls;

// --------------------------------------------------------------------------
public partial class ManageFormsPage : Page
{

	// ------------------------------------------------------------------------
	private string WorkingFormName
	{
		get { return ViewState[ "WorkingForm" ] as string; }
		set { ViewState[ "WorkingForm" ] = value; }
	} // WorkingFormName

	// ------------------------------------------------------------------------
	private static string FormsPath
	{
		get { return ConfigurationManager.AppSettings[ "FormsPath" ]; }
	} // FormsPath

	// ------------------------------------------------------------------------
	private static string LookupItemText
	{
		get { return ConfigurationManager.AppSettings[ "LookupItemText" ]; }
	} // LookupItemText

	// ------------------------------------------------------------------------
	private static string LookupItemValue
	{
		get { return ConfigurationManager.AppSettings[ "LookupItemValue" ]; }
	} // LookupItemValue

	// ------------------------------------------------------------------------
	private static int LookupItemCount
	{
		get { return int.Parse( ConfigurationManager.AppSettings[ "LookupItemCount" ] ); }
	} // LookupItemCount

	// ------------------------------------------------------------------------
	protected override void OnLoad( EventArgs e )
	{
		if ( !Page.IsPostBack )
		{
			SetupFormList();
		}

		SetupForm();
		base.OnLoad( e );
	} // OnLoad

	// ------------------------------------------------------------------------
	private void SetupForm()
	{
		FormPlaceHolder.Controls.Clear();

		string workingFormName = WorkingFormName;
		if ( string.IsNullOrEmpty( workingFormName ) )
		{
			return;
		}

		// load form control
		UserControl userForm = new UserFormLoader( workingFormName, "workForm" ).Load();
		FormPlaceHolder.Controls.Add( userForm );
		FormTitleLabel.Text = workingFormName;

		// lookups
		SetupLookups( userForm );

		// data-binding expressions
		DataBind();
	} // SetupForm

	// ------------------------------------------------------------------------
	private void SetupFormList()
	{
		string formsPath = FormsPath;
		if ( string.IsNullOrEmpty( formsPath ) )
		{
			throw new InvalidOperationException( "missing FormsPath setting" );
		}

		string physicalFormsPath = MapPath( formsPath );
		DirectoryInfo directoryInfo = new DirectoryInfo( physicalFormsPath );
		if ( Directory.Exists( directoryInfo.FullName ) )
		{
			foreach ( FileInfo fileInfo in directoryInfo.GetFiles( "*" + UserFormInfo.FileExtension ) )
			{
				FormListBox.Items.Add( new ListItem(
					fileInfo.Name.Replace( UserFormInfo.FileExtension, string.Empty ),
					formsPath + "/" + fileInfo.Name ) );
			}
		}

		if ( FormListBox.Items.Count > 0 )
		{
			FormListLabel.Visible = true;
			FormListBox.Visible = true;
			FormListBox.SelectedIndex = 0;
			WorkingFormName = FormListBox.Items[ 0 ].Value;
		}
		else
		{
			FormListLabel.Visible = false;
			FormListBox.Visible = false;
			FormTitleLabel.Text = "Please place a UserControl into the folder " + FormsPath;
		}
	} // SetupFormList

	// ------------------------------------------------------------------------
	private static void SetupLookups( Control control )
	{
		// lookup setup
		LookupFieldCollector lookupCollector = new LookupFieldCollector( control );
		lookupCollector.Collect();

		foreach ( ILookupField listBoxLookup in lookupCollector.LookupFields )
		{
			listBoxLookup.Items.Clear();

			for ( int i = 0; i < LookupItemCount; i++ )
			{
				listBoxLookup.Items.Add( new ListItem( 
					string.Format( LookupItemText, i + 1 ),
					string.Format( LookupItemValue, i + 1 ) ) );
			}

			if ( listBoxLookup.Items.Count > 0 )
			{
				listBoxLookup.Items[ 0 ].Selected = true;
			}
		}
	} // SetupLookups

	// ------------------------------------------------------------------------
	protected void SelectedFormChanged( object sender, EventArgs e )
	{
		WorkingFormName = FormListBox.SelectedValue;
		SetupForm();
	} // SelectedFormChanged

} // class ManageFormsPage
// -- EOF -------------------------------------------------------------------
