// -- FILE ------------------------------------------------------------------
// name       : IVariableSet.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System.Collections.Generic;

namespace Itenso.WebUserForms.Data.Variable
{

	// ------------------------------------------------------------------------
	public interface IVariableSet
	{

		// ----------------------------------------------------------------------
		int Count { get; }

		// ----------------------------------------------------------------------
		/// <summary>
		/// Provides access to the variables known by this instance.
		/// </summary>
		IEnumerable<string> VariableNames { get; }

		// ----------------------------------------------------------------------
		/// <summary>
		/// Provides access to the variable content.
		/// </summary>
		string this[ string variableName ] { get; }

		// ----------------------------------------------------------------------
		/// <summary>
		/// Maps some content text to a variable name. Replaces any previous such
		/// assignment if that variable had already been mapped earlier.
		/// </summary>
		/// <param name="variableName">the name of the variable to receive the
		/// given content. may not be null or empty.</param>
		/// <param name="content">the content for the given variable. may be empty
		/// but not null.</param>
		void MapContentToVariable( string variableName, string content );

		// ----------------------------------------------------------------------
		/// <summary>
		/// Maps object property values to variables.
		/// </summary>
		/// <param name="variableObject">the object containing the variable values.</param>
		void MapObjectPropertiesToVariables( object variableObject );

		// ----------------------------------------------------------------------
		/// <summary>
		/// Removes a variable.
		/// </summary>
		/// <param name="variableName">the name of the variable to remove.</param>
		void RemoveVariable( string variableName );

		// ----------------------------------------------------------------------
		/// <summary>
		/// Retrieves the replacement for a given variable.
		/// </summary>
		/// <param name="variableName">the name of the variable for which to determine
		/// the replacement content</param>
		/// <returns>the replacement content for the given variable. might return null
		/// if that variable isn't known by this instance.</returns>
		string GetVariableContent( string variableName );

		// ----------------------------------------------------------------------
		/// <summary>
		/// Expands all variable references in the the given text with the values
		/// from this instance. A variable reference has the form '${varName}' and
		/// will be replaced by the content for 'varName' from this instance. If no
		/// such variable is found, no replacement takes place and the reference is
		/// preserved as it is.
		/// </summary>
		/// <param name="textToExpand">the text to expand, possibly containing
		/// references to variables. may be null.</param>
		/// <returns>the expanded text. never null but possibly empty.</returns>
		string Expand( string textToExpand );

		// ----------------------------------------------------------------------
		/// <summary>
		/// Removes all variables.
		/// </summary>
		void Clear();

		// ----------------------------------------------------------------------
		/// <summary>
		/// Copy variables to another variable set.
		/// </summary>
		/// <param name="destination">the destination variable set.</param>
		/// <param name="nameFormat">destination name pattern like string.Format() (optional).</param>
		void CopyTo( IVariableSet destination, string nameFormat );

	} // interface IVariableSet

} // namespace Itenso.WebUserForms.Data.Variable
// -- EOF -------------------------------------------------------------------
