// -- FILE ------------------------------------------------------------------
// name       : FormItemBase.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;

namespace Itenso.WebUserForms.Data.Lookup
{

	// ------------------------------------------------------------------------
	public class LookupValue : ILookupValue
	{

		// ----------------------------------------------------------------------
		public LookupValue( string value )
			: this( value, value )
		{
		} // LookupValue

		// ----------------------------------------------------------------------
		public LookupValue( string key, object value )
		{
			if ( string.IsNullOrEmpty( key ) )
			{
				throw new ArgumentException( "key" );
			}
			if ( value == null )
			{
				throw new ArgumentNullException( "value" );
			}

			this.key = key;
			this.value = value;
		} // LookupValue

		// ----------------------------------------------------------------------
		public string Key
		{
			get { return this.key; }
		} // Key

		// ----------------------------------------------------------------------
		public object Value
		{
			get { return this.value; }
		} // Value

		// ----------------------------------------------------------------------
		public override bool Equals( object obj )
		{
			bool equal = false;
			LookupValue compare = obj as LookupValue;
			if ( compare != null )
			{
				equal =
					Equals( this.key, compare.key ) &&
					Equals( this.value, compare.value );
			}
			return equal;
		} // Equals

		// ----------------------------------------------------------------------
		public override int GetHashCode()
		{
			int hash = GetType().GetHashCode();
			hash = HashTool.AddHashCode( hash, key );
			hash = HashTool.AddHashCode( hash, value );
			return hash;
		} // GetHashCode

		// ----------------------------------------------------------------------
		public override string ToString()
		{
			return key + "=" + value;
		} // ToString

		// ----------------------------------------------------------------------
		// members
		private readonly string key;
		private readonly object value;

	} // class FormItemBase

} // namespace Itenso.WebUserForms.Data.Lookup
// -- EOF -------------------------------------------------------------------
