// -- FILE ------------------------------------------------------------------
// name       : LookupRepository.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Collections.Generic;

namespace Itenso.WebUserForms.Data.Lookup
{

	// ------------------------------------------------------------------------
	public abstract class LookupRepository : ILookupRepository
	{

		// ----------------------------------------------------------------------
		protected LookupRepository()
		{
		} // LookupRepository

		// ----------------------------------------------------------------------
		public ILookupValueCollection this[ string lookupName ]
		{
			get { return GetLookup( lookupName ); }
		} // this[string]

		// ----------------------------------------------------------------------
		public ILookupValueCollection GetLookup( string lookupName )
		{
			return GetLookup( lookupName, null );
		} // GetLookup

		// ----------------------------------------------------------------------
		public ILookupValueCollection GetLookup( string lookupName, string formType )
		{
			if ( string.IsNullOrEmpty( lookupName ) )
			{
				throw new ArgumentException( "lookupName" );
			}

			string lookupKey = GetLookupKey( lookupName, formType );
			if ( this.lookups.ContainsKey( lookupKey ) )
			{
				return this.lookups[ lookupKey ];
			}

			ILookupValueCollection lookupValues = OnLookupRequest( lookupName, formType );
			if ( lookupValues == null )
			{
				return null;
			}

			this.lookups.Add( lookupKey, lookupValues );
			return lookupValues;
		} // GetLookup

		// ----------------------------------------------------------------------
		public bool Contains( string lookupName )
		{
			return Contains( lookupName, null );
		} // Contains

		// ----------------------------------------------------------------------
		public bool Contains( string lookupName, string formType )
		{
			if ( string.IsNullOrEmpty( lookupName ) )
			{
				throw new ArgumentException( "lookupName" );
			}

			return this.lookups.ContainsKey( GetLookupKey( lookupName, formType ) );
		} // Contains

		// ----------------------------------------------------------------------
		public void Add( string lookupName, ILookupValueCollection lookupValues )
		{
			Add( lookupName, null, lookupValues );
		} // Add

		// ----------------------------------------------------------------------
		public void Add( string lookupName, string formType, ILookupValueCollection lookupValues )
		{
			if ( string.IsNullOrEmpty( lookupName ) )
			{
				throw new ArgumentException( "lookupName" );
			}

			this.lookups.Add( GetLookupKey( lookupName, formType ), lookupValues );
		} // Add

		// ----------------------------------------------------------------------
		public void Clear()
		{
			this.lookups.Clear();
		} // Clear

		// ----------------------------------------------------------------------
		public void Remove( string lookupName )
		{
			Remove( lookupName, null );
		} // Remove

		// ----------------------------------------------------------------------
		public void Remove( string lookupName, string formType )
		{
			if ( string.IsNullOrEmpty( lookupName ) )
			{
				throw new ArgumentException( "lookupName" );
			}

			string lookupKey = GetLookupKey( lookupName, formType );
			if ( !this.lookups.ContainsKey( lookupKey ) )
			{
				return;
			}

			this.lookups.Remove( lookupKey );
		} // Remove

		// ----------------------------------------------------------------------
		protected abstract ILookupValueCollection OnLookupRequest( string lookupName, string formType );

		// ----------------------------------------------------------------------
		private static string GetLookupKey( string lookupName, string formType )
		{
			if ( string.IsNullOrEmpty( formType ) )
			{
				return lookupName;
			}

			return string.Concat( lookupName, ".", formType );
		} // GetLookupKey

		// ----------------------------------------------------------------------
		// members
		private readonly Dictionary<string, ILookupValueCollection> lookups = 
			new Dictionary<string, ILookupValueCollection>();

	} // class LookupRepository

} // namespace Itenso.WebUserForms.Data.Lookup
// -- EOF -------------------------------------------------------------------
