// -- FILE ------------------------------------------------------------------
// name       : ILookupRepository.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------

namespace Itenso.WebUserForms.Data.Lookup
{

	// ------------------------------------------------------------------------
	public interface ILookupRepository : ILookupProvider
	{

		// ----------------------------------------------------------------------
		bool Contains( string lookupName, string formType );

		// ----------------------------------------------------------------------
		void Add( string lookupName, string formType,
			ILookupValueCollection lookupValues );

		// ----------------------------------------------------------------------
		/// <summary>
		/// Removes a lookup.
		/// </summary>
		/// <param name="lookupName">the name of the lookup to remove.</param>
		/// <param name="formType">the type of form.</param>
		void Remove( string lookupName, string formType );

		// ----------------------------------------------------------------------
		/// <summary>
		/// Removes all lookups.
		/// </summary>
		void Clear();

	} // interface ILookupRepository

} // namespace Itenso.WebUserForms.Data.Lookup
// -- EOF -------------------------------------------------------------------
