// -- FILE ------------------------------------------------------------------
// name       : IFormGroup.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------

namespace Itenso.WebUserForms.Data.Form
{

	// ------------------------------------------------------------------------
	public interface IFormGroup : IFormEntity
	{

		// ----------------------------------------------------------------------
		IFormEntityCollection Entities { get; }

		// ----------------------------------------------------------------------
		new IFormGroup Duplicate();

		// ----------------------------------------------------------------------
		/// <summary>
		/// Provides convenience access to the items of this instance or any of the
		/// contained child forms (via dotted syntax). E.g. searching for an item
		/// with the name 'foo' will retrieve the field which is contained in this
		/// instance whereas a query for 'foo.sub.item' will look for an item named
		/// 'item' in the form 'sub' in this instances child form 'foo'. if any of
		/// the fields along the search path are non-existent, null will be returned.
		/// </summary>
		/// <param name="itemNameOrPath">the reference to the item to find. may be a simple
		/// name or a dotted reference to a child item.</param>
		/// <returns>the found item or null if not found</returns>
		IFormEntity FindByItemPath( string itemNameOrPath );

		// ----------------------------------------------------------------------
		/// <summary>
		/// Provides convenience search access to an individual field.
		/// </summary>
		/// <param name="fieldName">the name of the field to find</param>
		/// <returns>the field with the given name or null if no such field could be
		/// found or if the found item with the given path is not a field (but rather
		/// a form)</returns>
		IFormField FindFieldByPath( string fieldName );

		// ----------------------------------------------------------------------
		/// <summary>
		/// Provides convenience search access to an individual form.
		/// </summary>
		/// <param name="groupName">the name of the group to find</param>
		/// <returns>the form with the given name or null if no such form could be
		/// found or if the found item with the given path is not a form (but rather
		/// a field)</returns>
		IFormGroup FindGroupByPath( string groupName );

	} // interface IFormGroup

} // namespace Itenso.WebUserForms.Data.Form
// -- EOF -------------------------------------------------------------------
