// -- FILE ------------------------------------------------------------------
// name       : IFormEntity.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using Itenso.WebUserForms.Data.Variable;

namespace Itenso.WebUserForms.Data.Form
{

	// ------------------------------------------------------------------------
	public interface IFormEntity
	{

		// ----------------------------------------------------------------------
		FormEntityType Kind { get; }

		// ----------------------------------------------------------------------
		string Name { get; set; }

		// ----------------------------------------------------------------------
		IFormEntity Duplicate();

		// ----------------------------------------------------------------------
		/// <summary>
		/// Expands all variable references in the fields contents with the values
		/// from the given variable set. A reference has the form '${varName}' and
		/// will be replaced by the content for 'varName' from the given variable
		/// set. If no such variable is found in the given set, no replacement takes
		/// place and the reference is preserved as it is.
		/// </summary>
		/// <param name="varSet">the set containing replacements for a variables.</param>
		void ExpandVariables( IVariableSet varSet );

	} // interface IFormEntity

} // namespace Itenso.WebUserForms.Data.Form
// -- EOF -------------------------------------------------------------------
