// -- FILE ------------------------------------------------------------------
// name       : IForm.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;

namespace Itenso.WebUserForms.Data.Form
{

	// ------------------------------------------------------------------------
	public interface IForm : IFormGroup
	{

		// ----------------------------------------------------------------------
		string FormType { get; set; }

		// ----------------------------------------------------------------------
		string FormId { get; set; }

		// ----------------------------------------------------------------------
		string FormVersion { get; set; }

		// ----------------------------------------------------------------------
		DateTime Created { get; set; }

		// ----------------------------------------------------------------------
		string CreatedByUser { get; set; }

		// ----------------------------------------------------------------------
		DateTime LastUpdated { get; set; }

		// ----------------------------------------------------------------------
		string LastUpdatedByUser { get; set; }

		// ----------------------------------------------------------------------
		bool IsLocked { get; set; }

		// ----------------------------------------------------------------------
		bool IsNew { get; }

		// ----------------------------------------------------------------------
		void SetCreated( DateTime moment, string user );

		// ----------------------------------------------------------------------
		new IForm Duplicate();

		// ----------------------------------------------------------------------
		/// <summary>
		/// Sets the moment of the last update.
		/// </summary>
		/// <param name="moment">the moment of the update, must be equal to or after
		/// the creation time</param>
		/// <param name="user">the user performing the update, must not be empty</param>
		void MarkUpdated( DateTime moment, string user );

	} // interface IForm

} // namespace Itenso.WebUserForms.Data.Form
// -- EOF -------------------------------------------------------------------
