// -- FILE ------------------------------------------------------------------
// name       : FormXmlSchema.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System.Xml;
using System.Xml.Schema;

namespace Itenso.WebUserForms.Data.Form
{

	// ------------------------------------------------------------------------
	public sealed class FormXmlSchema : XmlSchemaBase
	{

		// ----------------------------------------------------------------------
		private FormXmlSchema()
		{
		} // FormXmlSchema

		// ----------------------------------------------------------------------
		public static XmlSchema Schema
		{
			get
			{
				if ( schema == null )
				{
					lock ( mutex )
					{
						if ( schema == null )
						{
							schema = LoadSchema( typeof( FormXmlSchema ), "Form.xsd" );
						}
					}
				}
				return schema;
			}
		} // Schema

		// ----------------------------------------------------------------------
		/// <exception cref="System.Xml.Schema.XmlSchemaException">in case of a schema error</exception>
		public static XmlReaderSettings XmlReadSettings
		{
			get
			{
				if ( readSettings == null )
				{
					lock ( mutex )
					{
						if ( readSettings == null )
						{
							readSettings = CreateStrictSchemaValidationSettings( Schema );
						}
					}
				}
				return readSettings;
			}
		} // XmlReadSettings

		// ----------------------------------------------------------------------
		// members
		private static readonly object mutex = new object();
		private static volatile XmlSchema schema;
		private static volatile XmlReaderSettings readSettings;

	} // class FormXmlSchema

} // namespace Itenso.WebUserForms.Data.Form
// -- EOF -------------------------------------------------------------------
