// -- FILE ------------------------------------------------------------------
// name       : FormGroup.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using Itenso.WebUserForms.Data.Variable;

namespace Itenso.WebUserForms.Data.Form
{

	// ------------------------------------------------------------------------
	public class FormGroup : FormEntity, IFormGroup
	{

		// ----------------------------------------------------------------------
		/// <summary>
		/// for internal use only!
		/// </summary>
		public FormGroup()
			: base( FormEntityType.Form )
		{
		} // FormGroup

		// ----------------------------------------------------------------------
		public FormGroup( string name )
			: base( FormEntityType.Form, name )
		{
		} // FormGroup

		// ----------------------------------------------------------------------
		public FormGroup( FormGroup copy )
			: base( copy )
		{
			foreach ( IFormEntity item in copy.entities )
			{
				this.entities.Add( item.Duplicate() );
			}
		} // FormGroup

		// ----------------------------------------------------------------------
		protected override IFormEntity DoDuplicate()
		{
			return new FormGroup( this );
		} // DoDuplicate

		// ----------------------------------------------------------------------
		IFormGroup IFormGroup.Duplicate()
		{
			return DoDuplicate() as FormGroup;
		} // IFormGroup.Duplicate

		// ----------------------------------------------------------------------
		public IFormEntityCollection Entities
		{
			get { return this.entities; }
		} // Entities

		// ----------------------------------------------------------------------
		public IFormEntity FindByItemPath( string itemNameOrPath )
		{
			if ( itemNameOrPath != null )
			{
				int indexOfFirstDot = itemNameOrPath.IndexOf( '.' );
				if ( indexOfFirstDot > 0 )
				{
					string itemName = itemNameOrPath.Substring( 0, indexOfFirstDot );
					IFormGroup formGroup = this.entities.FindByItemName( itemName ) as IFormGroup;
					if ( formGroup != null )
					{
						string restReference = itemNameOrPath.Substring( indexOfFirstDot + 1 );
						return formGroup.FindByItemPath( restReference );
					}
				}
				else
				{
					return entities.FindByItemName( itemNameOrPath );
				}
			}
			return null;
		} // FindByItemPath

		// ----------------------------------------------------------------------
		public IFormField FindFieldByPath( string fieldName )
		{
			return FindByItemPath( fieldName ) as IFormField;
		} // FindFieldByPath

		// ----------------------------------------------------------------------
		public IFormGroup FindGroupByPath( string groupName )
		{
			return FindByItemPath( groupName ) as IFormGroup;
		} // FindGroupByPath

		// ----------------------------------------------------------------------
		protected override void DoExpandVariables( IVariableSet varSet )
		{
			foreach ( IFormEntity item in this.entities )
			{
				item.ExpandVariables( varSet );
			}
		} // DoExpandVariables

		// ----------------------------------------------------------------------
		public override bool Equals( object obj )
		{
			bool equal = false;
			FormGroup compare = obj as FormGroup;
			if ( compare != null )
			{
				equal = base.Equals( obj ) &&
					Equals( this.entities, compare.entities );
			}
			return equal;
		} // Equals

		// ----------------------------------------------------------------------
		public override int GetHashCode()
		{
			int hash = base.GetHashCode();
			hash = HashTool.AddHashCode( hash, this.entities );
			return hash;
		} // GetHashCode

		// ----------------------------------------------------------------------
		public override string ToString()
		{
			return base.ToString() + ": " + this.entities;
		} // ToString

		// ----------------------------------------------------------------------
		// members
		private readonly FormEntityCollection entities = new FormEntityCollection();

	} // class FormGroup

} // namespace Itenso.WebUserForms.Data.Form
// -- EOF -------------------------------------------------------------------
