// -- FILE ------------------------------------------------------------------
// name       : FormField.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using Itenso.WebUserForms.Data.Variable;

namespace Itenso.WebUserForms.Data.Form
{

	// ------------------------------------------------------------------------
	public sealed class FormField : FormEntity, IFormField
	{

		// ----------------------------------------------------------------------
		/// <summary>
		/// for internal use only!
		/// </summary>
		public FormField() 
			: base( FormEntityType.Field )
		{
		} // FormField

		// ----------------------------------------------------------------------
		public FormField( string name )
			: this( name, null )
		{
		} // FormField

		// ----------------------------------------------------------------------
		public FormField( string name, string content ) 
			: base( FormEntityType.Field, name )
		{
			this.content = content;
		} // FormField

		// ----------------------------------------------------------------------
		public FormField( FormField copy ) 
			: base( copy )
		{
			this.content = copy.content;
		} // FormField

		// ----------------------------------------------------------------------
		protected override IFormEntity DoDuplicate()
		{
			return new FormField( this );
		} // DoDuplicate

		// ----------------------------------------------------------------------
		public IFormField Duplicate()
		{
			return DoDuplicate() as IFormField;
		} // Duplicate

		// ----------------------------------------------------------------------
		public string Content
		{
			get { return this.content; }
			set { this.content = value; }
		} // Content

		// ----------------------------------------------------------------------
		protected override void DoExpandVariables( IVariableSet varSet )
		{
			this.content = varSet.Expand( this.content );
		} // DoExpandVariables

		// ----------------------------------------------------------------------
		public override bool Equals( object obj )
		{
			bool equal = false;
			FormField compare = obj as FormField;
			if ( compare != null )
			{
				equal = base.Equals( obj ) &&
					Equals( this.content, compare.content );
			}
			return equal;
		} // Equals

		// ----------------------------------------------------------------------
		public override int GetHashCode()
		{
			int hash = base.GetHashCode();
			hash = HashTool.AddHashCode( hash, this.content );
			return hash;
		} // GetHashCode

		// ----------------------------------------------------------------------
		public override string ToString()
		{
			return base.ToString() + "='" + this.content + "'";
		} // ToString

		// ----------------------------------------------------------------------
		// members
		private string content;

	} // class FormField

} // namespace Itenso.WebUserForms.Data.Form
// -- EOF -------------------------------------------------------------------
