// -- FILE ------------------------------------------------------------------
// name       : FormEntityCollection.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Collections;
using System.Collections.Generic;

namespace Itenso.WebUserForms.Data.Form
{

	// ------------------------------------------------------------------------
	public sealed class FormEntityCollection : IFormEntityCollection
	{

		// ----------------------------------------------------------------------
		/// <summary>
		/// Creates a new empty instance.
		/// </summary>
		public FormEntityCollection()
		{
		} // FormEntityCollection

		// ----------------------------------------------------------------------
		/// <summary>
		/// Creates a new instance with all the items of the given collection.
		/// </summary>
		/// <param name="entities">the entities to add. may not be null.</param>
		public FormEntityCollection( IEnumerable<IFormEntity> entities )
		{
			AddAll( entities );
		} // FormEntityCollection

		// ----------------------------------------------------------------------
		IEnumerator IEnumerable.GetEnumerator()
		{
			return this.items.GetEnumerator();
		} // IEnumerable.GetEnumerator

		// ----------------------------------------------------------------------
		public IEnumerator<IFormEntity> GetEnumerator()
		{
			return this.items.GetEnumerator();
		} // GetEnumerator

		// ----------------------------------------------------------------------
		public int Count
		{
			get { return this.items.Count; }
		} // Count

		// ----------------------------------------------------------------------
		public IFormEntity this[ int index ]
		{
			get { return this.items[ index ]; }
		} // this[]

		// ----------------------------------------------------------------------
		public int IndexOf( IFormEntity entity )
		{
			return this.items.IndexOf( entity );
		} // IndexOf

		// ----------------------------------------------------------------------
		public int Add( IFormEntity entity )
		{
			if ( entity == null )
			{
				throw new ArgumentNullException( "entity" );
			}
			int insertPos = items.Count;
			this.items.Add( entity );
			return insertPos;
		} // Add

		// ----------------------------------------------------------------------
		public void Add( IFormEntity entity, int pos )
		{
			if ( entity == null )
			{
				throw new ArgumentNullException( "entity" );
			}
			this.items.Insert( pos, entity );
		} // Add

		// ----------------------------------------------------------------------
		public void AddAll( IEnumerable<IFormEntity> entities )
		{
			if ( entities == null )
			{
				throw new ArgumentNullException( "entities" );
			}
			foreach ( IFormEntity entity in entities )
			{
				Add( entity );
			}
		} // AddAll

		// ----------------------------------------------------------------------
		public void Remove( IFormEntity entity )
		{
			this.items.Remove( entity );
		} // Remove

		// ----------------------------------------------------------------------
		public void RemoveAt( int index )
		{
			this.items.RemoveAt( index );
		} // RemoveAt

		// ----------------------------------------------------------------------
		public void Clear()
		{
			this.items.Clear();
		} // Clear

		// ----------------------------------------------------------------------
		public IFormEntity[] ToArray()
		{
			IFormEntity[] entries = new IFormEntity[ Count ];
			if ( entries.Length > 0 )
			{
				CopyTo( entries, 0 );
			}
			return entries;
		} // ToArray

		// ----------------------------------------------------------------------
		public void CopyTo( IFormEntity[] array, int index )
		{
			this.items.CopyTo( array, index );
		} // CopyTo

		// ----------------------------------------------------------------------
		public override bool Equals( object obj )
		{
			return CollectionTool.AreEqual( this, obj );
		} // Equals

		// ----------------------------------------------------------------------
		public override int GetHashCode()
		{
			return CollectionTool.ComputeHashCode( this );
		} // GetHashCode

		// ----------------------------------------------------------------------
		public override string ToString()
		{
			return CollectionTool.ToString( this );
		} // ToString

		// ----------------------------------------------------------------------
		public IFormEntity FindByItemName( string itemName )
		{
			foreach ( IFormEntity item in this )
			{
				if ( item.Name.Equals( itemName ) )
				{
					return item;
				}
			}
			return null;
		} // FindByItemName

		// ----------------------------------------------------------------------
		public IFormField FindFieldByName( string fieldName )
		{
			return FindByItemName( fieldName ) as IFormField;
		} // FindFieldByName

		// ----------------------------------------------------------------------
		public IForm FindFormByName( string formName )
		{
			return FindByItemName( formName ) as IForm;
		} // FindFormByName

		// ----------------------------------------------------------------------
		// members
		private readonly List<IFormEntity> items = new List<IFormEntity>();

	} // class FormEntityCollection

} // namespace Itenso.WebUserForms.Data.Form
// -- EOF -------------------------------------------------------------------
