// -- FILE ------------------------------------------------------------------
// name       : FormEntity.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using Itenso.WebUserForms.Data.Variable;

namespace Itenso.WebUserForms.Data.Form
{

	// ------------------------------------------------------------------------
	public abstract class FormEntity : IFormEntity
	{

		// ----------------------------------------------------------------------
		/// <summary>
		/// for internal use only!
		/// </summary>
		protected FormEntity( FormEntityType kind )
		{
			this.kind = kind;
		} // FormEntity

		// ----------------------------------------------------------------------
		protected FormEntity( FormEntityType kind, string name )
		{
			if ( string.IsNullOrEmpty( name ) )
			{
				throw new ArgumentNullException( "name" );
			}
			this.kind = kind;
			this.name = name;
		} // FormEntity

		// ----------------------------------------------------------------------
		protected FormEntity( FormEntity copy )
		{
			if ( copy == null )
			{
				throw new ArgumentNullException( "copy" );
			}
			this.kind = copy.kind;
			this.name = copy.name;
		} // FormEntity

		// ----------------------------------------------------------------------
		public FormEntityType Kind
		{
			get { return this.kind; }
		} // Kind

		// ----------------------------------------------------------------------
		public string Name
		{
			get { return this.name; }
			set { this.name = value; }
		} // Name

		// ----------------------------------------------------------------------
		IFormEntity IFormEntity.Duplicate()
		{
			return DoDuplicate();
		} // IFormItem.Duplicate

		// ----------------------------------------------------------------------
		protected abstract IFormEntity DoDuplicate();

		// ----------------------------------------------------------------------
		public void ExpandVariables( IVariableSet varSet )
		{
			if ( varSet != null && varSet.Count > 0 )
			{
				DoExpandVariables( varSet );
			}
		} // ExpandVariables

		// ----------------------------------------------------------------------
		protected abstract void DoExpandVariables( IVariableSet varSet );

		// ----------------------------------------------------------------------
		public override bool Equals( object obj )
		{
			bool equal = false;
			FormEntity compare = obj as FormEntity;
			if ( compare != null )
			{
				equal =
					Equals( this.kind, compare.kind ) &&
					Equals( this.name, compare.name );
			}
			return equal;
		} // Equals

		// ----------------------------------------------------------------------
		public override int GetHashCode()
		{
			int hash = GetType().GetHashCode();
			hash = HashTool.AddHashCode( hash, this.kind );
			hash = HashTool.AddHashCode( hash, this.name );
			return hash;
		} // GetHashCode

		// ----------------------------------------------------------------------
		public override string ToString()
		{
			return this.kind + "-" + this.name;
		} // ToString

		// ----------------------------------------------------------------------
		// members
		private readonly FormEntityType kind;
		private string name;

	} // class FormEntity

} // namespace Itenso.WebUserForms.Data.Form
// -- EOF -------------------------------------------------------------------
