// -- FILE ------------------------------------------------------------------
// name       : Form.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;

namespace Itenso.WebUserForms.Data.Form
{

	// ------------------------------------------------------------------------
	public class Form : FormGroup, IForm
	{

		// ----------------------------------------------------------------------
		/// <summary>
		/// for internal use only!
		/// </summary>
		public Form() 
		{
		} // Form

		// ----------------------------------------------------------------------
		public Form( string name ) 
			: base( name )
		{
		} // Form

		// ----------------------------------------------------------------------
		public Form( Form copy ) : 
			base( copy )
		{
		} // Form

		// ----------------------------------------------------------------------
		public string FormType
		{
			get { return this.type; }
			set { this.type = value; }
		} // FormType

		// ----------------------------------------------------------------------
		public string FormId
		{
			get { return this.formId; }
			set { this.formId = value; }
		} // FormId

		// ----------------------------------------------------------------------
		public string FormVersion
		{
			get { return this.formVersion; }
			set { this.formVersion = value; }
		} // FormVersion

		// ----------------------------------------------------------------------
		public DateTime Created
		{
			get { return this.created; }
			set { this.created = value; }
		} // Created

		// ----------------------------------------------------------------------
		public string CreatedByUser
		{
			get { return this.createdBy; }
			set { this.createdBy = value; }
		} // CreatedByUser

		// ----------------------------------------------------------------------
		public DateTime LastUpdated
		{
			get { return this.updated; }
			set { this.updated = value; }
		} // LastUpdated

		// ----------------------------------------------------------------------
		public string LastUpdatedByUser
		{
			get { return this.updatedBy; }
			set { this.updatedBy = value; }
		} // LastUpdatedByUser

		// ----------------------------------------------------------------------
		public bool IsLocked
		{
			get { return this.isLocked; }
			set { this.isLocked = value; }
		} // IsLocked

		// ----------------------------------------------------------------------
		public bool IsNew
		{
			get { return string.IsNullOrEmpty( this.formId ); }
		} // IsNew

		// ----------------------------------------------------------------------
		public void SetCreated( DateTime moment, string user )
		{
			if ( string.IsNullOrEmpty( user ) )
			{
				throw new ArgumentNullException( "user" );
			}

			this.created = moment;
			this.updated = moment;
			this.createdBy = user;
			this.updatedBy = user;
		} // SetCreated

		// ----------------------------------------------------------------------
		public void MarkUpdated( DateTime moment, string user )
		{
			if ( moment.CompareTo( created ) < 0 )
			{
				throw new ArgumentException( "moment" );
			}
			if ( string.IsNullOrEmpty( user ) )
			{
				throw new ArgumentNullException( "user" );
			}

			this.updated = moment;
			this.updatedBy = user;
		} // MarkUpdated

		// ----------------------------------------------------------------------
		protected override IFormEntity DoDuplicate()
		{
			return new Form( this );
		} // DoDuplicate

		// ----------------------------------------------------------------------
		IForm IForm.Duplicate()
		{
			return DoDuplicate() as IForm;
		} // IFormData.Duplicate

		// ----------------------------------------------------------------------
		public override bool Equals( object obj )
		{
			bool equal = false;
			Form compare = obj as Form;
			if ( compare != null )
			{
				equal = base.Equals( obj ) &&
					Equals( this.type, compare.type ) &&
					Equals( this.formId, compare.formId ) &&
					Equals( this.formVersion, compare.formVersion ) &&
					Equals( this.created, compare.created ) &&
					Equals( this.createdBy, compare.createdBy ) &&
					Equals( this.updated, compare.updated ) &&
					Equals( this.updatedBy, compare.updatedBy ) &&
					Equals( this.isLocked, compare.isLocked );
			}
			return equal;
		} // Equals

		// ----------------------------------------------------------------------
		public override int GetHashCode()
		{
			int hash = base.GetHashCode();
			hash = HashTool.AddHashCode( hash, this.type );
			hash = HashTool.AddHashCode( hash, this.formId );
			hash = HashTool.AddHashCode( hash, this.formVersion );
			hash = HashTool.AddHashCode( hash, this.created );
			hash = HashTool.AddHashCode( hash, this.createdBy );
			hash = HashTool.AddHashCode( hash, this.updated );
			hash = HashTool.AddHashCode( hash, this.updatedBy );
			hash = HashTool.AddHashCode( hash, this.isLocked );
			return hash;
		} // GetHashCode

		// ----------------------------------------------------------------------
		// members
		private string type;
		private string formId;
		private string formVersion;
		private DateTime created;
		private string createdBy;
		private DateTime updated;
		private string updatedBy;
		private bool isLocked;

	} // class Form

} // namespace Itenso.WebUserForms.Data.Form
// -- EOF -------------------------------------------------------------------
