﻿// -- FILE ------------------------------------------------------------------
// name       : VisibleVariable.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System.Drawing;
using System.ComponentModel;

namespace Itenso.WebUserForms.Controls
{

#if VAR_FIELDS

	// ------------------------------------------------------------------------
	[DefaultProperty( "FieldName" )]
	[Designer( typeof( ExpressionFieldDesigner ) )]
	[ToolboxBitmap( typeof( ResFinder ), "Itenso.WebUserForms.Controls.Images.VisibleVariable.png" )]
	public class VisibleVariable : System.Web.UI.WebControls.Label, IExpressionField
	{

		// ----------------------------------------------------------------------
		public VisibleVariable()
		{
		} // VisibleVariable

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "VisibleVariable Form Field Name" )]
		[Category( "Web User Forms" )]
		public string FieldName
		{
			get { return this.fieldName; }
			set { this.fieldName = value; }
		} // FieldName

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "VisibleVariable Form Field Value" )]
		[Category( "Web User Forms" )]
		public string FieldValue
		{
			get { return Text; }
			set { Text = value; }
		} // FieldValue

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "VisibleVariable Form Field Expression" )]
		[Category( "Web User Forms" )]
		public string FieldExpression
		{
			get { return this.fieldExpression; }
			set { this.fieldExpression = value; }
		} // FieldExpression

		// ----------------------------------------------------------------------
		[Browsable( false )]
		bool IUserFormField.AllowEdit
		{
			get { return false; }
			set { }
		} // AllowEdit

		// ----------------------------------------------------------------------
		public override string ToString()
		{
			return FormFieldTool.GetFieldDescription( this );
		} // ToString

		// ----------------------------------------------------------------------
		// members
		private string fieldName;
		private string fieldExpression;

	} // class VisibleVariable

#endif // VAR_FIELDS

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
