﻿// -- FILE ------------------------------------------------------------------
// name       : ValidatorEnabler.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System.Web.UI;
using System.Web.UI.WebControls;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	public class ValidatorEnabler : UserFormVisitor
	{

		// ----------------------------------------------------------------------
		public ValidatorEnabler( Control startControl, bool enabled )
			: base( startControl )
		{
			this.enabled = enabled;
		} // ValidatorEnabler

		// ----------------------------------------------------------------------
		public bool Enabled
		{
			get { return this.enabled; }
		} // Enabled

		// ----------------------------------------------------------------------
		public void Enable()
		{
			Start();
		} // Enable

		// ----------------------------------------------------------------------
		public static void Enable( Control startControl, bool enabled )
		{
			ValidatorEnabler validatorEnabler = new ValidatorEnabler( startControl, enabled );
			validatorEnabler.Enable();
		} // Enable

		// ----------------------------------------------------------------------
		protected override void VisitControl( Control control )
		{
			BaseValidator baseValidator = control as BaseValidator;
			if ( baseValidator != null )
			{
				baseValidator.Enabled = enabled;
			}
		} // VisitControl

		// ----------------------------------------------------------------------
		// members
		private readonly bool enabled;

	} // class ValidatorEnabler

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
