﻿// -- FILE ------------------------------------------------------------------
// name       : UserFormLoader.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Web.UI;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	public class UserFormLoader
	{

		// ----------------------------------------------------------------------
		public UserFormLoader( string virtualPath )
			: this( virtualPath, null )
		{
		} // UserFormLoader

		// ----------------------------------------------------------------------
		public UserFormLoader( string virtualPath, string formId )
		{
			if ( string.IsNullOrEmpty( virtualPath ) )
			{
				throw new ArgumentNullException( "virtualPath" );
			}

			this.virtualPath = virtualPath;
			this.formId = formId;
		} // UserFormLoader

		// ----------------------------------------------------------------------
		public string VirtualPath
		{
			get { return this.virtualPath; }
		} // VirtualPath

		// ----------------------------------------------------------------------
		public string FormId
		{
			get { return this.formId; }
		} // FormId

		// ----------------------------------------------------------------------
		public UserControl LoadUnsafe()
		{
			return LoadControl( null );
		} // LoadUnsafe

		// ----------------------------------------------------------------------
		public UserControl Load()
		{
			return LoadControl( new UserFormCodeValidator() );
		} // Load

		// ----------------------------------------------------------------------
		public UserControl Load( UserFormCodeValidator codeValidator )
		{
			if ( codeValidator == null )
			{
				throw new ArgumentNullException( "codeValidator" );
			}
			return LoadControl( codeValidator );
		} // Load

		// ----------------------------------------------------------------------
		private UserControl LoadControl( UserFormCodeValidator codeValidator )
		{
			UserControl userControl = new UserControl().LoadControl( this.virtualPath ) as UserControl;

			if ( codeValidator != null )
			{
				codeValidator.Validate( userControl );
			}

			SetupForm( userControl );

			return userControl;
		} // LoadControl

		// ----------------------------------------------------------------------
		protected virtual void SetupForm( UserControl userControl )
		{
			if ( string.IsNullOrEmpty( this.formId ) )
			{
				return;
			}
			if ( userControl != null && string.IsNullOrEmpty( userControl.ID ) )
			{
				userControl.ID = this.formId;
			}
		} // SetupForm

		// ----------------------------------------------------------------------
		// members
		private readonly string virtualPath;
		private readonly string formId;

	} // class UserFormLoader

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
