// -- FILE ------------------------------------------------------------------
// name       : UserFormInfoDesigner.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Web.UI.Design;
using System.ComponentModel;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	public class UserFormInfoDesigner : ControlDesigner
	{

		// ----------------------------------------------------------------------
		public override string GetDesignTimeHtml()
		{
			return CreatePlaceHolderDesignTimeHtml( null );
		} // GetDesignTimeHtml

		// ----------------------------------------------------------------------
		public override void Initialize( IComponent component )
		{
			// Throw an exception if the designer is attached
			// to a control for which it is not intended
			if ( !( component is UserFormInfoControl ) )
			{
				throw new InvalidOperationException(
					this.GetType().FullName + " only supports controls derived from UserFormInfoControl" );
			}

			base.Initialize( component );
		} // Initialize

	} // class UserFormInfoDesigner

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
