﻿// -- FILE ------------------------------------------------------------------
// name       : UserFormInfoControl.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.ComponentModel;
using System.Drawing;
using System.Web.UI.WebControls;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	[ToolboxBitmap( typeof( ResFinder ), "Itenso.WebUserForms.Controls.Images.UserFormInfo.png" )]
	[Designer( typeof( UserFormInfoDesigner ) )]
	public class UserFormInfoControl : CompositeControl
	{

		// ----------------------------------------------------------------------
		[DefaultValue( true )]
		[Description( "UserFormInfoControl Show Update Button" )]
		[Category( "Web User Forms" )]
		public bool ShowUpdateButton
		{
			get { return this.showUpdateButton; }
			set { this.showUpdateButton = value; }
		} // ShowUpdateButton

		// ----------------------------------------------------------------------
		[DefaultValue( true )]
		[Description( "UserFormInfoControl Show Design-Time Header Info" )]
		[Category( "Web User Forms" )]
		public bool ShowDesigntimeHeaderInfo
		{
			get { return this.showDesigntimeHeaderInfo; }
			set { this.showDesigntimeHeaderInfo = value; }
		} // ShowDesigntimeHeaderInfo

		// ----------------------------------------------------------------------
		[DefaultValue( false )]
		[Description( "UserFormInfoControl Show Run-Time Header Info" )]
		[Category( "Web User Forms" )]
		public bool ShowRuntimeHeaderInfo
		{
			get { return this.showRuntimeHeaderInfo; }
			set { this.showRuntimeHeaderInfo = value; }
		} // ShowRuntimeHeaderInfo

		// ----------------------------------------------------------------------
		protected override void OnPreRender( EventArgs e )
		{
			base.OnPreRender( e );
			CreateControls();
		} // OnPreRender

		// ----------------------------------------------------------------------
		private void CreateControls()
		{
			Controls.Clear();

			if ( this.showUpdateButton )
			{
				Button updateButton = new Button();
				updateButton.Text = "Update Form Info";
				updateButton.Click += UpdateButtonClick;
				Controls.Add( updateButton );
			}

			BuildFormInfo();
		} // CreateControls

		// ----------------------------------------------------------------------
		private void BuildFormInfo()
		{
			Table infoTable = new Table();
			infoTable.Width = Unit.Percentage( 100 );
			infoTable.CellPadding = 2;
			infoTable.CellSpacing = 1;

			UserFormInfoRenderer renderer = new UserFormInfoRenderer( Page.Form );
			renderer.ShowDesigntimeHeaderInfo = this.showDesigntimeHeaderInfo;
			renderer.ShowRuntimeHeaderInfo = this.showRuntimeHeaderInfo;
			renderer.Render( infoTable );
			if ( infoTable.Rows.Count > 1 )
			{
				Controls.Add( infoTable );
			}
		} // BuildFormInfo

		// ----------------------------------------------------------------------
		private void UpdateButtonClick( object sender, EventArgs e )
		{
			RecreateChildControls();
		} // UpdateButtonClick

		// ----------------------------------------------------------------------
		// members
		private bool showUpdateButton = true;
		private bool showDesigntimeHeaderInfo = true;
		private bool showRuntimeHeaderInfo;

	} // class UserFormInfoControl

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
