﻿// -- FILE ------------------------------------------------------------------
// name       : UserFormInfo.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	public class UserFormInfo : IUserFormInfo
	{

		// ----------------------------------------------------------------------
		public const string FileExtension = ".ascx";

		// ----------------------------------------------------------------------
		public UserFormInfo( string formId )
			: this( formId, null, null, null, null, null, null, null, null )
		{
		} // UserFormInfo

		// ----------------------------------------------------------------------
		public UserFormInfo( string formId, string formType, string name,
			string description, string version, DateTime? created, string createdByUser,
			DateTime? lastUpdated, string lastUpdatedByUser )
		{
			if ( string.IsNullOrEmpty( formId ) )
			{
				throw new ArgumentNullException( "formId" );
			}
			this.formId = formId;
			this.formType = formType;
			this.name = name;
			this.description = description;
			this.version = version;
			this.created = created;
			this.createdByUser = createdByUser;
			this.lastUpdated = lastUpdated;
			this.lastUpdatedByUser = lastUpdatedByUser;
		} // UserFormInfo

		// ----------------------------------------------------------------------
		public string FormId
		{
			get { return this.formId; }
		} // FormId

		// ----------------------------------------------------------------------
		public string FormType
		{
			get { return this.formType; }
		} // FormType

		// ----------------------------------------------------------------------
		public string Name
		{
			get { return this.name; }
		} // Name

		// ----------------------------------------------------------------------
		public string Description
		{
			get { return this.description; }
		} // Description

		// ----------------------------------------------------------------------
		public string Version
		{
			get { return this.version; }
		} // Version

		// ----------------------------------------------------------------------
		public DateTime? Created
		{
			get { return this.created; }
		} // Created

		// ----------------------------------------------------------------------
		public string CreatedByUser
		{
			get { return this.createdByUser; }
		} // CreatedByUser

		// ----------------------------------------------------------------------
		public DateTime? LastUpdated
		{
			get { return this.lastUpdated; }
		} // LastUpdated

		// ----------------------------------------------------------------------
		public string LastUpdatedByUser
		{
			get { return this.lastUpdatedByUser; }
		} // LastUpdatedByUser

		// ----------------------------------------------------------------------
		// members
		private readonly string formId;
		private readonly string formType;
		private readonly string name;
		private readonly string description;
		private readonly string version;
		private readonly DateTime? created;
		private readonly string createdByUser;
		private readonly DateTime? lastUpdated;
		private readonly string lastUpdatedByUser;

	} // class UserFormInfo

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
