// -- FILE ------------------------------------------------------------------
// name       : UserFormHeaderDesigner.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Text;
using System.Web.UI.Design;
using System.ComponentModel;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	public class UserFormHeaderDesigner : ControlDesigner
	{

		// ----------------------------------------------------------------------
		public override string GetDesignTimeHtml()
		{
			UserFormHeader formHeader = Component as UserFormHeader;
			if ( formHeader == null )
			{
				return string.Empty;
			}

			StringBuilder sb = new StringBuilder();
			sb.Append( formHeader.ToString() );
			if ( string.IsNullOrEmpty( formHeader.Type ) )
			{
				if ( sb.Length != 0 )
				{
					sb.Append( "<br />" );
				}
				sb.Append( "- Missing value of 'Type'" );
			}
			if ( string.IsNullOrEmpty( formHeader.Name ) )
			{
				if ( sb.Length != 0 )
				{
					sb.Append( "<br />" );
				}
				sb.Append( "- Missing value of 'Name'" );
			}

			return CreatePlaceHolderDesignTimeHtml( sb.ToString() );
		} // GetDesignTimeHtml

		// ----------------------------------------------------------------------
		public override void Initialize( IComponent component )
		{
			// Throw an exception if the designer is attached
			// to a control for which it is not intended
			if ( !(component is UserFormHeader) )
			{
				throw new InvalidOperationException(
					this.GetType().FullName  + " only supports controls derived from Form" );
			}

			base.Initialize( component );
		} // Initialize

	} // class UserFormHeaderDesigner

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
