// -- FILE ------------------------------------------------------------------
// name       : UserFormHeaderBuilder.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Web.UI;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	public class UserFormHeaderBuilder : ControlBuilder
	{

		// ----------------------------------------------------------------------
		/// <summary>
		/// Treat whitespace literals as empty
		/// </summary>
		public override bool AllowWhitespaceLiterals()
		{
			return false;
		} // AllowWhitespaceLiterals

		// ----------------------------------------------------------------------
		/// <summary>
		/// When adding child controls, throw an exception
		/// unless child is a DataBoundLiteralControl
		/// </summary>
		/// <param name="subBuilder">Control builder of child control</param>
		public override void AppendSubBuilder( ControlBuilder subBuilder )
		{
			if ( subBuilder.ControlType == null )
			{
				// This allows codeblocks to be added in the
				// inner text of the control
				base.AppendSubBuilder( subBuilder );
			}
			else
			{
				throw new InvalidOperationException(
					string.Format( "Control {0} may not contain {1}", ControlType.FullName, subBuilder.ControlType.FullName ) );
			}
		} // AppendSubBuilder

	} // class UserFormHeaderBuilder

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
