﻿// -- FILE ------------------------------------------------------------------
// name       : UserFormHeader.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Drawing;
using System.ComponentModel;
using System.Web.UI;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	[DefaultProperty( "Name" )]
	[ToolboxBitmap( typeof( ResFinder ), "Itenso.WebUserForms.Controls.Images.UserForm.png" )]
	[ControlBuilder( typeof( UserFormHeaderBuilder ) )]
	[Designer( typeof( UserFormHeaderDesigner ) )]
	public class UserFormHeader : System.Web.UI.WebControls.HiddenField, IUserFormHeader
	{

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "UserFormHeader Form Type" )]
		[Category( "Web User Forms" )]
		public string Type
		{
			get { return this.type; }
			set { this.type = value; }
		} // Type

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "UserFormHeader Form Name" )]
		[Category( "Web User Forms" )]
		public string Name
		{
			get { return this.name; }
			set { this.name = value; }
		} // Name

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "UserFormHeader Description" )]
		[Category( "Web User Forms" )]
		public string Description
		{
			get { return this.description; }
			set { this.description = value; }
		} // Description

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "UserFormHeader Version" )]
		[Category( "Web User Forms" )]
		public string Version
		{
			get { return this.version; }
			set { this.version = value; }
		} // Version

		// ----------------------------------------------------------------------
		[Browsable( false )]
		public string FormId
		{
			get { return ViewState[ "FormId" ] as string; }
			set { ViewState[ "FormId" ] = value; }
		} // FormId

		// ----------------------------------------------------------------------
		[Browsable( false )]
		public string FormType
		{
			get { return ViewState[ "FormType" ] as string; }
			set { ViewState[ "FormType" ] = value; }
		} // FormType

		// ----------------------------------------------------------------------
		[Browsable( false )]
		public string FormName
		{
			get { return ViewState[ "FormName" ] as string; }
			set { ViewState[ "FormName" ] = value; }
		} // FormName

		// ----------------------------------------------------------------------
		[Browsable( false )]
		public DateTime? FormCreated
		{
			get 
			{
				object created = ViewState[ "FormCreated" ];
				if ( created != null )
				{
					return (DateTime)created;
				}

				return null;
			}
			set { ViewState[ "FormCreated" ] = value; }
		} // FormCreated

		// ----------------------------------------------------------------------
		[Browsable( false )]
		public string FormCreatedByUser
		{
			get { return ViewState[ "FormCreatedByUser" ] as string; }
			set { ViewState[ "FormCreatedByUser" ] = value; }
		} // FormCreatedByUser

		// ----------------------------------------------------------------------
		[Browsable( false )]
		public DateTime? FormLastUpdated
		{
			get
			{
				object created = ViewState[ "FormLastUpdated" ];
				if ( created != null )
				{
					return (DateTime)created;
				}

				return null;
			}
			set { ViewState[ "FormLastUpdated" ] = value; }
		} // FormLastUpdated

		// ----------------------------------------------------------------------
		[Browsable( false )]
		public string FormLastUpdatedByUser
		{
			get { return ViewState[ "FormLastUpdatedByUser" ] as string; }
			set { ViewState[ "FormLastUpdatedByUser" ] = value; }
		} // FormLastUpdatedByUser

		// ----------------------------------------------------------------------
		[Browsable( false )]
		public string FormVersion
		{
			get { return ViewState[ "FormVersion" ] as string; }
			set { ViewState[ "FormVersion" ] = value; }
		} // FormVersion

		// ----------------------------------------------------------------------
		public override string ToString()
		{
			if ( string.IsNullOrEmpty( this.type ) )
			{
				return string.IsNullOrEmpty( this.name ) ?
					string.Empty : this.name;
			}

			return string.IsNullOrEmpty( this.name ) ?
				this.type : string.Concat( this.type, " - ", name );
		} // ToString

		// ----------------------------------------------------------------------
		// members
		private string type;
		private string name;
		private string description;
		private string version;

	} // class UserFormHeader

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
