// -- FILE ------------------------------------------------------------------
// name       : UserFormFieldCollection.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Collections;
using System.Collections.Generic;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	public class UserFormFieldCollection : IUserFormFieldCollection
	{

		// ----------------------------------------------------------------------
		public UserFormFieldCollection()
		{
		} // UserFormFieldCollection

		// ----------------------------------------------------------------------
		public int Count
		{
			get { return this.fields.Count; }
		} // Count

		// ----------------------------------------------------------------------
		public IUserFormField this[ int index ]
		{
			get { return this.fields[ index ]; }
		} // this[]

		// ----------------------------------------------------------------------
		public int IndexOf( IUserFormField field )
		{
			return this.fields.IndexOf( field );
		} // IndexOf

		// ----------------------------------------------------------------------
		public IEnumerator<IUserFormField> GetEnumerator()
		{
			return this.fields.GetEnumerator();
		} // GetEnumerator

		// ----------------------------------------------------------------------
		IEnumerator IEnumerable.GetEnumerator()
		{
			return this.fields.GetEnumerator();
		} // IEnumerable.GetEnumerator

		// ----------------------------------------------------------------------
		public IUserFormField FindByFieldName( string fieldName )
		{
			foreach ( IUserFormField field in this.fields )
			{
				if ( field.FieldName.Equals( fieldName ) )
				{
					return field;
				}
			}
			return null;
		} // FindByFieldName

		// ----------------------------------------------------------------------
		public int Add( IUserFormField field )
		{
			if ( field == null )
			{
				throw new ArgumentNullException( "field" );
			}
			int insertPos = fields.Count;
			this.fields.Add( field );
			return insertPos;
		} // Add

		// ----------------------------------------------------------------------
		public void Add( IUserFormField field, int pos )
		{
			this.fields.Insert( pos, field );
		} // Add

		// ----------------------------------------------------------------------
		public void AddAll( IEnumerable<IUserFormField> items )
		{
			if ( items == null )
			{
				throw new ArgumentNullException( "items" );
			}
			foreach ( IUserFormField item in items )
			{
				Add( item );
			}
		} // AddAll

		// ----------------------------------------------------------------------
		public void Remove( IUserFormField item )
		{
			this.fields.Remove( item );
		} // Remove

		// ----------------------------------------------------------------------
		public void RemoveAt( int index )
		{
			this.fields.RemoveAt( index );
		} // RemoveAt

		// ----------------------------------------------------------------------
		public void Clear()
		{
			this.fields.Clear();
		} // Clear

		// ----------------------------------------------------------------------
		public IUserFormField[] ToArray()
		{
			IUserFormField[] entries = new IUserFormField[ Count ];
			if ( entries.Length > 0 )
			{
				CopyTo( entries, 0 );
			}
			return entries;
		} // ToArray

		// ----------------------------------------------------------------------
		public void CopyTo( IUserFormField[] array, int index )
		{
			this.fields.CopyTo( array, index );
		} // CopyTo

		// ----------------------------------------------------------------------
		// members
		private readonly List<IUserFormField> fields = new List<IUserFormField>();

	} // class UserFormFieldCollection

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
