﻿// -- FILE ------------------------------------------------------------------
// name       : UserFormCommandManager.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	public class UserFormCommandManager
	{

		// ----------------------------------------------------------------------
		public event CommandEventHandler Command;

		// ----------------------------------------------------------------------
		public UserFormCommandManager( UserControl userControl )
		{
			if ( userControl == null )
			{
				throw new ArgumentNullException( "userControl" );
			}

			this.userControl = userControl;
			this.userControl.Load += UserControlLoad;
			this.userControl.Unload += UserControlUnload;
		} // UserFormCommandManager

		// ----------------------------------------------------------------------
		public UserControl UserControl
		{
			get { return this.userControl; }
		} // UserControl

		// ----------------------------------------------------------------------
		public bool HasCommand( string commandName )
		{
			if ( string.IsNullOrEmpty( commandName) )
			{
				throw new ArgumentNullException( "commandName" );
			}

			if ( this.formCommands == null || this.formCommands.Count == 0 )
			{
				return false;
			}

			foreach ( IUserFormCommand formCommand in formCommands )
			{
				if ( commandName.Equals( formCommand.CommandName ) )
				{
					return true;
				}
			}

			return false;
		} // HasCommand

		// ----------------------------------------------------------------------
		public void EnableCommand( string commandName, bool enabled )
		{
			if ( string.IsNullOrEmpty( commandName ) )
			{
				throw new ArgumentNullException( "commandName" );
			}

			if ( this.formCommands == null || this.formCommands.Count == 0 )
			{
				return;
			}

			commandName = commandName.ToLower();
			foreach ( IUserFormCommand formCommand in formCommands )
			{
				if ( commandName.Equals( formCommand.CommandName.ToLower() ) )
				{
					formCommand.Enabled = enabled;
				}
			}
		} // EnableCommand

		// ----------------------------------------------------------------------
		protected virtual void OnCommand( IUserFormCommand formCommand, CommandEventArgs e )
		{
			if ( Command != null )
			{
				Command( formCommand, e );
			}
		} // OnCommand

		// ----------------------------------------------------------------------
		private void RegisterEvents()
		{
			this.formCommands = CommandCollector.Collect( this.userControl );
			if ( this.formCommands == null || this.formCommands.Count == 0 )
			{
				return;
			}

			foreach ( IUserFormCommand formCommand in formCommands )
			{
				formCommand.Command += FormCommandCommand;
			}
		} // RegisterEvents

		// ----------------------------------------------------------------------
		private void UnregisterEvents()
		{
			if ( this.formCommands == null || this.formCommands.Count == 0 )
			{
				return;
			}

			foreach ( IUserFormCommand formCommand in formCommands )
			{
				formCommand.Command -= FormCommandCommand;
			}
		} // UnregisterEvents

		// ----------------------------------------------------------------------
		private void FormCommandCommand( object sender, CommandEventArgs e )
		{
			IUserFormCommand formCommand = sender as IUserFormCommand;
			if ( formCommand == null )
			{
				return;
			}

			OnCommand( formCommand, e );
		} // FormCommandCommand

		// ----------------------------------------------------------------------
		private void UserControlLoad( object sender, EventArgs e )
		{
			RegisterEvents();
		} // UserControlLoad

		// ----------------------------------------------------------------------
		private void UserControlUnload( object sender, EventArgs e )
		{
			UnregisterEvents();
		} // UserControlUnload

		// ----------------------------------------------------------------------
		// members
		private readonly UserControl userControl;
		private List<IUserFormCommand> formCommands;

	} // class UserFormCommandManager

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
