// -- FILE ------------------------------------------------------------------
// name       : UserFormCommandDesigner.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.IO;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.Design;
using System.Drawing;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	public class UserFormCommandDesigner : ControlDesigner
	{

		// ----------------------------------------------------------------------
		public UserFormCommandDesigner()
		{
		} // UserFormCommandDesigner

		// ----------------------------------------------------------------------
		protected Control DesignControl
		{
			get { return Component as Control; }
		} // DesignControl

		// ----------------------------------------------------------------------
		protected Color MissingCommandNameColor
		{
			get { return this.missingCommandNameColor; }
			set { this.missingCommandNameColor = value; }
		} // MissingCommandNameColor

		// ----------------------------------------------------------------------
		protected string CommandName
		{
			get
			{
				IUserFormCommand formCommand = Component as IUserFormCommand;
				if ( formCommand == null )
				{
					throw new InvalidOperationException( "IUserFormCommand required" );
				}
				return formCommand.CommandName;
			}
		} // CommandName

		// ----------------------------------------------------------------------
		protected bool HasCommandName
		{
			get { return !string.IsNullOrEmpty( CommandName ); }
		} // HasCommandName

		// ----------------------------------------------------------------------
		public override string GetDesignTimeHtml()
		{
			Control designControl = DesignControl;
			if ( designControl == null )
			{
				return base.GetDesignTimeHtml();
			}

			WebControl designWebControl = designControl as WebControl;
			if ( designWebControl != null )
			{
				designWebControl.BackColor = GetStatusColor();
			}
			return GetRenderHtml( designControl );
		} // GetDesignTimeHtml

		// ----------------------------------------------------------------------
		protected virtual Color GetStatusColor()
		{
			if ( !HasCommandName )
			{
				return MissingCommandNameColor;
			}

			return Color.Empty;
		} // GetStatusColor

		// ----------------------------------------------------------------------
		protected virtual string GetRenderHtml( Control control )
		{
			StringWriter text = new StringWriter();
			HtmlTextWriter writer = new HtmlTextWriter( text );
			control.RenderControl( writer );
			return text.ToString();
		} // GetRenderHtml

		// ----------------------------------------------------------------------
		// members
		private Color missingCommandNameColor = Color.Red;

	} // class UserFormCommandDesigner

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
