﻿// -- FILE ------------------------------------------------------------------
// name       : UserFormCollector.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Web.UI;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	public static class UserFormCollector
	{

		// ----------------------------------------------------------------------
		public static UserForm CollectUserForm( UserControl userControl )
		{
			if ( userControl == null )
			{
				throw new ArgumentNullException( "userControl" );
			}
			if ( userControl.Controls.Count == 0 )
			{
				return null;
			}

			return ParseUserForm( userControl, null );
		} // CollectUserForm

		// ----------------------------------------------------------------------
		private static UserForm ParseUserForm( Control control, UserForm userForm )
		{
			if ( control.Controls.Count == 0 )
			{
				return null;
			}

			IUserFormHeader formHeader = FindFormHeader( control.Controls );
			if ( userForm == null ) // main form
			{
				if ( formHeader == null ) // header on root form is required
				{
					throw new FormHeaderException( "missing form header" );
				}
				if ( string.IsNullOrEmpty( formHeader.Type ) )
				{
					throw new FormHeaderException( "invalid form header type", formHeader );
				}
				if ( string.IsNullOrEmpty( formHeader.Name ) )
				{
					throw new FormHeaderException( "invalid form header name", formHeader );
				}
				userForm = new UserForm( formHeader );
			}
			else if ( formHeader != null ) // found sub form
			{
				UserForm subform = new UserForm( formHeader );
				userForm.Subforms.Add( subform );
				userForm = subform;
			}

			CollectFormFields( control.Controls, userForm );
			foreach ( Control subControl in control.Controls )
			{
				ParseUserForm( subControl, userForm );
			}

			return userForm;
		} // ParseUserForm

		// ----------------------------------------------------------------------
		private static IUserFormHeader FindFormHeader( ControlCollection controls )
		{
			foreach ( Control control in controls )
			{
				IUserFormHeader formHeader = control as IUserFormHeader;
				if ( formHeader != null )
				{
					return formHeader;
				}
			}
			return null;
		} // FindFormHeader

		// ----------------------------------------------------------------------
		private static void CollectFormFields( ControlCollection controls, IUserForm form )
		{
			foreach ( Control control in controls )
			{
				IUserFormField formField = control as IUserFormField;
				if ( formField == null )
				{
					continue;
				}

				if ( string.IsNullOrEmpty( formField.FieldName ) )
				{
					throw new FormFieldException( "missing field name", formField );
				}

				form.Fields.Add( formField );
			}
		} // CollectFormFields

	} // class UserFormCollector

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
