// -- FILE ------------------------------------------------------------------
// name       : UserFormCollection.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Collections;
using System.Collections.Generic;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	public class UserFormCollection : IUserFormCollection
	{

		// ----------------------------------------------------------------------
		public UserFormCollection()
		{
		} // UserFormCollection

		// ----------------------------------------------------------------------
		public int Count
		{
			get { return this.forms.Count; }
		} // Count

		// ----------------------------------------------------------------------
		public IUserForm this[ int index ]
		{
			get { return this.forms[ index ]; }
		} // this[]

		// ----------------------------------------------------------------------
		public IEnumerator<IUserForm> GetEnumerator()
		{
			return this.forms.GetEnumerator();
		} // GetEnumerator

		// ----------------------------------------------------------------------
		IEnumerator IEnumerable.GetEnumerator()
		{
			return this.forms.GetEnumerator();
		} // IEnumerable.GetEnumerator


		// ----------------------------------------------------------------------
		public int IndexOf( IUserForm form )
		{
			return this.forms.IndexOf( form );
		} // IndexOf

		// ----------------------------------------------------------------------
		public IUserForm FindByFormName( string formName )
		{
			foreach ( IUserForm form in this.forms )
			{
				if ( form.Header.Name.Equals( formName ) )
				{
					return form;
				}
			}
			return null;
		} // FindByFormName

		// ----------------------------------------------------------------------
		public int Add( IUserForm form )
		{
			if ( form == null )
			{
				throw new ArgumentNullException( "form" );
			}
			int insertPos = forms.Count;
			this.forms.Add( form );
			return insertPos;
		} // Add

		// ----------------------------------------------------------------------
		public void Add( IUserForm form, int pos )
		{
			this.forms.Insert( pos, form );
		} // Add

		// ----------------------------------------------------------------------
		public void AddAll( IEnumerable<IUserForm> items )
		{
			if ( items == null )
			{
				throw new ArgumentNullException( "items" );
			}
			foreach ( IUserForm item in items )
			{
				Add( item );
			}
		} // AddAll

		// ----------------------------------------------------------------------
		public void Remove( IUserForm item )
		{
			this.forms.Remove( item );
		} // Remove

		// ----------------------------------------------------------------------
		public void RemoveAt( int index )
		{
			this.forms.RemoveAt( index );
		} // RemoveAt

		// ----------------------------------------------------------------------
		public void Clear()
		{
			this.forms.Clear();
		} // Clear

		// ----------------------------------------------------------------------
		public IUserForm[] ToArray()
		{
			IUserForm[] entries = new IUserForm[ Count ];
			if ( entries.Length > 0 )
			{
				CopyTo( entries, 0 );
			}
			return entries;
		} // ToArray

		// ----------------------------------------------------------------------
		public void CopyTo( IUserForm[] array, int index )
		{
			this.forms.CopyTo( array, index );
		} // CopyTo

		// ----------------------------------------------------------------------
		// members
		private readonly List<IUserForm> forms = new List<IUserForm>();

	} // class UserFormCollection

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
