﻿// -- FILE ------------------------------------------------------------------
// name       : UserForm.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	public class UserForm : IUserForm
	{

		// ----------------------------------------------------------------------
		public UserForm( IUserFormHeader header )
		{
			if ( header == null )
			{
				throw new ArgumentNullException( "header" );
			}
			this.header = header;
		} // UserForm

		// ----------------------------------------------------------------------
		public IUserFormFieldCollection Fields
		{
			get { return this.fields; }
		} // Fields

		// ----------------------------------------------------------------------
		public IUserFormCollection Subforms
		{
			get { return this.subforms; }
		} // Subforms

		// ----------------------------------------------------------------------
		public IUserFormHeader Header
		{
			get { return this.header; }
		} // Header

		// ----------------------------------------------------------------------
		// members
		private readonly IUserFormHeader header;
		private readonly UserFormFieldCollection fields = new UserFormFieldCollection();
		private readonly UserFormCollection subforms = new UserFormCollection();

	} // class UserForm

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
