﻿// -- FILE ------------------------------------------------------------------
// name       : TimePicker.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System.Drawing;
using System.ComponentModel;
using System.Web.UI;

namespace Itenso.WebUserForms.Controls
{

#if TP_DATE_FIELDS

	// ------------------------------------------------------------------------
	[DefaultProperty( "FieldName" )]
	[Designer( typeof( UserFormFieldDesigner ) )]
	[ToolboxBitmap( typeof( ResFinder ), "Itenso.WebUserForms.Controls.Images.TimePicker.png" )]
	public class TimePicker : System.Web.UI.WebControls.TextBox, IUserFormField, IPlaceholderControl
	{

		// ----------------------------------------------------------------------
		public TimePicker()
		{
			base.ReadOnly = true;
		} // TimePicker

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "TimePicker Form Field Name" )]
		[Category( "Web User Forms" )]
		public string FieldName
		{
			get { return this.fieldName; }
			set { this.fieldName = value; }
		} // FieldName

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "TimePicker Form Field Value" )]
		[Category( "Web User Forms" )]
		public string FieldValue
		{
			get { return Text; }
			set { Text = value; }
		} // FieldValue

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "TimePicker Form Field Time Format" )]
		[Category( "Web User Forms" )]
		public string TimeFormat
		{
			get { return this.timeFormat; }
			set { this.timeFormat = value; }
		} // TimeFormat

		// ----------------------------------------------------------------------
		[Browsable( false )]
		bool IUserFormField.AllowEdit
		{
			get { return false; }
			set { }
		} // AllowEdit

		// ----------------------------------------------------------------------
		[Browsable( false )]
		Control IPlaceholderControl.Control
		{
			get { return this; }
		} // IPlaceholderControl.Control

		// ----------------------------------------------------------------------
		public override bool ReadOnly
		{
			get { return base.ReadOnly; }
			set { }
		} // ReadOnly

		// ----------------------------------------------------------------------
		public override string ToString()
		{
			return FormFieldTool.GetFieldDescription( this );
		} // ToString

		// ----------------------------------------------------------------------
		// members
		private string fieldName;
		private string timeFormat;

	} // class TimePicker

#endif // TP_DATE_FIELDS

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
