﻿// -- FILE ------------------------------------------------------------------
// name       : TextBox.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System.Drawing;
using System.ComponentModel;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	[DefaultProperty( "FieldName" )]
	[Designer( typeof( UserFormFieldDesigner ) )]
	[ToolboxBitmap( typeof( ResFinder ), "Itenso.WebUserForms.Controls.Images.TextEdit.png" )]
	public class TextBox : System.Web.UI.WebControls.TextBox, IUserFormField
	{

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "TextBox Form Field Name" )]
		[Category( "Web User Forms" )]
		public string FieldName
		{
			get { return this.fieldName; }
			set { this.fieldName = value; }
		} // FieldName

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "TextBox Form Field Value" )]
		[Category( "Web User Forms" )]
		public string FieldValue
		{
			get { return Text; }
			set { Text = value; }
		} // FieldValue

		// ----------------------------------------------------------------------
		[Browsable( false )]
		bool IUserFormField.AllowEdit
		{
			get { return !ReadOnly; }
			set { ReadOnly = !value; }
		} // AllowEdit

		// ----------------------------------------------------------------------
		public override string ToString()
		{
			return FormFieldTool.GetFieldDescription( this );
		} // ToString

		// ----------------------------------------------------------------------
		// members
		private string fieldName;

	} // class TextBox

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
