﻿// -- FILE ------------------------------------------------------------------
// name       : RadioButtonList.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Drawing;
using System.ComponentModel;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	[DefaultProperty( "FieldName" )]
	[Designer( typeof( UserFormFieldDesigner ) )]
	[ToolboxBitmap( typeof( ResFinder ), "Itenso.WebUserForms.Controls.Images.RadioButtonList.png" )]
	public class RadioButtonList : System.Web.UI.WebControls.RadioButtonList, IListField
	{

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "RadioButtonList Form Field Name" )]
		[Category( "Web User Forms" )]
		public string FieldName
		{
			get { return this.fieldName; }
			set { this.fieldName = value; }
		} // FieldName

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "RadioButtonList Form Field Value" )]
		[Category( "Web User Forms" )]
		public string FieldValue
		{
			get { return ListControlTool.GetSelectionValue( this ); }
			set
			{
				ListControlTool.ResetItemSelection( this );
				ListControlTool.SetSelectionValue( this, value );
			}
		} // FieldValue

		// ----------------------------------------------------------------------
		[Browsable( false )]
		bool IUserFormField.AllowEdit
		{
			get { return Enabled; }
			set { Enabled = value; }
		} // AllowEdit

		// ----------------------------------------------------------------------
		[Browsable( false )]
		public string OnClickClientScript
		{
			get { return this.onClickClientScript; }
			set { this.onClickClientScript = value; }
		} // OnClickClientScript

		// ----------------------------------------------------------------------
		protected override void OnPreRender( EventArgs e )
		{
			base.OnPreRender( e );
			if ( !string.IsNullOrEmpty( this.onClickClientScript ) )
			{
				Attributes.Add( "onClick", this.onClickClientScript );
			}
		} // OnPreRender

		// ----------------------------------------------------------------------
		public override string ToString()
		{
			return FormFieldTool.GetFieldDescription( this );
		} // ToString

		// ----------------------------------------------------------------------
		// members
		private string fieldName;
		private string onClickClientScript;

	} // class RadioButtonList

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
