﻿// -- FILE ------------------------------------------------------------------
// name       : LookupListBoxLookupListBox.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System.Drawing;
using System.ComponentModel;

namespace Itenso.WebUserForms.Controls
{

#if LOOKUP_FIELDS

	// ------------------------------------------------------------------------
	[DefaultProperty( "FieldName" )]
	[Designer( typeof( LookupFieldDesigner ) )]
	[ToolboxBitmap( typeof( ResFinder ), "Itenso.WebUserForms.Controls.Images.LookupListBox.png" )]
	public class LookupListBox : ListBox, ILookupField
	{

		// ----------------------------------------------------------------------
		public LookupListBox()
		{
		} // LookupListBox

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "LookupListBox Form Field Lookup Name" )]
		[Category( "Web User Forms" )]
		public string LookupName
		{
			get { return this.lookupName; }
			set { this.lookupName = value; }
		} // LookupName

		// ----------------------------------------------------------------------
		// members
		private string lookupName;

	} // class LookupListBox

#endif // LOOKUP_FIELDS

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
