// -- FILE ------------------------------------------------------------------
// name       : LookupFieldDesigner.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Drawing;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	public class LookupFieldDesigner : UserFormFieldDesigner
	{

		// ----------------------------------------------------------------------
		public LookupFieldDesigner()
		{
		} // LookupFieldDesigner

		// ----------------------------------------------------------------------
		protected Color MissingLookupNameColor
		{
			get { return this.missingLookupNameColor; }
			set { this.missingLookupNameColor = value; }
		} // MissingLookupNameColor

		// ----------------------------------------------------------------------
		protected string LookupName
		{
			get
			{
				ILookupField lookupField = Component as ILookupField;
				if ( lookupField == null )
				{
					throw new InvalidOperationException( "ILookupField required" );
				}
				return lookupField.LookupName;
			}
		} // LookupName

		// ----------------------------------------------------------------------
		protected bool HasLookupName
		{
			get { return !string.IsNullOrEmpty( LookupName ); }
		} // HasLookupName

		// ----------------------------------------------------------------------
		protected override Color GetStatusColor()
		{
			if ( !HasLookupName )
			{
				return MissingLookupNameColor;
			}

			return base.GetStatusColor();
		} // GetStatusColor

		// ----------------------------------------------------------------------
		// members
		private Color missingLookupNameColor = Color.LightCyan;

	} // class LookupFieldDesigner

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
