﻿// -- FILE ------------------------------------------------------------------
// name       : LookupCollector.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Web.UI;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	public class LookupFieldCollector : UserFormVisitor
	{

		// ----------------------------------------------------------------------
		public LookupFieldCollector( Control startControl )
			: base( startControl )
		{
		} // LookupCollector

		// ----------------------------------------------------------------------
		public LookupFieldCollector( Control startControl, string lookupName )
			: this( startControl )
		{
			if ( string.IsNullOrEmpty( lookupName ) )
			{
				throw new ArgumentException( "lookupName" );
			}

			this.lookupName = lookupName;
		} // LookupCollector

		// ----------------------------------------------------------------------
		public string LookupName
		{
			get { return this.lookupName; }
		} // LookupName

		// ----------------------------------------------------------------------
		public List<ILookupField> LookupFields
		{
			get { return this.lookupFields; }
		} // LookupFields

		// ----------------------------------------------------------------------
		public void Collect()
		{
			this.lookupFields.Clear();
			Start();
		} // Collect

		// ----------------------------------------------------------------------
		public static List<ILookupField> Collect( Control startControl )
		{
			return Collect( startControl, null );
		} // Collect

		// ----------------------------------------------------------------------
		public static List<ILookupField> Collect( Control startControl, string lookupName )
		{
			LookupFieldCollector lookupFieldCollector = new LookupFieldCollector( startControl, lookupName );
			lookupFieldCollector.Collect();
			return lookupFieldCollector.LookupFields;
		} // Collect

		// ----------------------------------------------------------------------
		protected override void VisitLookupFormField( Control control,
			ILookupField lookupField, IUserFormHeader formHeader )
		{
			bool match = true;

			if ( !string.IsNullOrEmpty( this.lookupName ) )
			{
				match = this.lookupName.Equals( lookupField.LookupName );
			}

			if ( match )
			{
				this.lookupFields.Add( lookupField );
			}
		} // VisitLookupFormField

		// ----------------------------------------------------------------------
		// members
		private readonly List<ILookupField> lookupFields = new List<ILookupField>();
		private readonly string lookupName;

	} // class LookupCollector

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
