﻿// -- FILE ------------------------------------------------------------------
// name       : LookupDropDownList.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System.Drawing;
using System.ComponentModel;

namespace Itenso.WebUserForms.Controls
{

#if LOOKUP_FIELDS

	// ------------------------------------------------------------------------
	[DefaultProperty( "FieldName" )]
	[Designer( typeof( LookupFieldDesigner ) )]
	[ToolboxBitmap( typeof( ResFinder ), "Itenso.WebUserForms.Controls.Images.LookupDropDownList.png" )]
	public class LookupDropDownList : DropDownList, ILookupField
	{

		// ----------------------------------------------------------------------
		public LookupDropDownList()
		{
		} // LookupDropDownList

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "LookupDropDownList Form Field Lookup Name" )]
		[Category( "Web User Forms" )]
		public string LookupName
		{
			get { return this.lookupName; }
			set { this.lookupName = value; }
		} // LookupName

		// ----------------------------------------------------------------------
		// members
		private string lookupName;

	} // class LookupDropDownList

#endif // LOOKUP_FIELDS

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
