﻿// -- FILE ------------------------------------------------------------------
// name       : LookupComboBoxLookupComboBox.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System.Drawing;
using System.ComponentModel;
using System.Web.UI;

namespace Itenso.WebUserForms.Controls
{

#if (LOOKUP_FIELDS && TP_COMBO_FIELDS)

	// ------------------------------------------------------------------------
	[DefaultProperty( "FieldName" )]
	[Designer( typeof( LookupFieldDesigner ) )]
	[ToolboxBitmap( typeof( ResFinder ), "Itenso.WebUserForms.Controls.Images.LookupComboBox.png" )]
	public class LookupComboBox : ComboBox, ILookupField, IPlaceholderControl
	{

		// ----------------------------------------------------------------------
		public LookupComboBox()
		{
		} // LookupComboBox

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "LookupComboBox Form Field Lookup Name" )]
		[Category( "Web User Forms" )]
		public string LookupName
		{
			get { return this.lookupName; }
			set { this.lookupName = value; }
		} // LookupName

		// ----------------------------------------------------------------------
		[Browsable( false )]
		Control IPlaceholderControl.Control
		{
			get { return this; }
		} // IPlaceholderControl.Control

		// ----------------------------------------------------------------------
		// members
		private string lookupName;

	} // class LookupComboBox

#endif // LOOKUP_FIELDS && TP_COMBO_FIELDS

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
