﻿// -- FILE ------------------------------------------------------------------
// name       : ListControlTool.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System.Text;
using System.Web.UI.WebControls;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	internal sealed class ListControlTool
	{

		// ----------------------------------------------------------------------
		public static string GetSelectionValue( ListControl listControl )
		{
			if ( listControl == null )
			{
				return null;
			}

			if ( listControl.Items.Count == 0 )
			{
				return string.Empty;
			}

			StringBuilder sb = new StringBuilder();
			foreach ( ListItem listItem in listControl.Items )
			{
				if ( !listItem.Selected )
				{
					continue;
				}

				if ( sb.Length > 0 )
				{
					sb.Append( itemDelimiter );
				}
				sb.Append( listItem.Value );
			}
			return sb.ToString();
		} // GetSelectionValue

		// ----------------------------------------------------------------------
		public static void ResetItemSelection( ListControl listControl )
		{
			SetItemSelection( listControl, false );
		} // ResetItemSelection

		// ----------------------------------------------------------------------
		public static void SetItemSelection( ListControl listControl, bool selected )
		{
			foreach ( ListItem listItem in listControl.Items )
			{
				listItem.Selected = selected;
			}
		} // SetItemSelection

		// ----------------------------------------------------------------------
		public static void SetSelectionValue( ListControl listControl, string value )
		{
			if ( listControl == null || string.IsNullOrEmpty( value ) )
			{
				return;
			}

			string[] itemValues = value.Split( itemDelimiter );
			foreach ( string itemValue in itemValues )
			{
				string trimValue = itemValue.Trim();
				if ( string.IsNullOrEmpty( trimValue ) )
				{
					continue;
				}

				ListItem listItem = listControl.Items.FindByValue( trimValue );
				if ( listItem == null )
				{
					continue;
				}

				listItem.Selected = true;
			}
		} // GetSelectionValue

		// ----------------------------------------------------------------------
		// members
		private const char itemDelimiter = '|';

	} // class ListControlTool

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
