﻿// -- FILE ------------------------------------------------------------------
// name       : ListBox.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System.Drawing;
using System.ComponentModel;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	[DefaultProperty( "FieldName" )]
	[Designer( typeof( UserFormFieldDesigner ) )]
	[ToolboxBitmap( typeof( ResFinder ), "Itenso.WebUserForms.Controls.Images.ListBox.png" )]
	public class ListBox : System.Web.UI.WebControls.ListBox, IListField
	{

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "ListBox Form Field Name" )]
		[Category( "Web User Forms" )]
		public string FieldName
		{
			get { return this.fieldName; }
			set { this.fieldName = value; }
		} // FieldName

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "ListBox Form Field Value" )]
		[Category( "Web User Forms" )]
		public string FieldValue
		{
			get { return ListControlTool.GetSelectionValue( this ); }
			set
			{
				ListControlTool.ResetItemSelection( this );
				ListControlTool.SetSelectionValue( this, value );
			}
		} // FieldValue

		// ----------------------------------------------------------------------
		[Browsable( false )]
		bool IUserFormField.AllowEdit
		{
			get { return Enabled; }
			set { Enabled = value; }
		} // AllowEdit

		// ----------------------------------------------------------------------
		public override string ToString()
		{
			return FormFieldTool.GetFieldDescription( this );
		} // ToString

		// ----------------------------------------------------------------------
		// members
		private string fieldName;

	} // class ListBox

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
