// -- FILE ------------------------------------------------------------------
// name       : IUserFormFieldCollection.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System.Collections.Generic;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	public interface IUserFormFieldCollection : IEnumerable<IUserFormField>
	{

		// ----------------------------------------------------------------------
		/// <summary>
		/// Access to the number of items.
		/// </summary>
		/// <value>the number of items in the collection</value>
		int Count { get; }

		// ----------------------------------------------------------------------
		/// <summary>
		/// Index access to the items of this collection.
		/// </summary>
		/// <param name="index">the index of the item to retrieve</param>
		/// <returns>the item at the given position</returns>
		IUserFormField this[ int index ] { get; }

		// ----------------------------------------------------------------------
		/// <summary>
		/// Provides the index of an element in this collection.
		/// </summary>
		/// <param name="item">The element whose index is to be returned.</param>
		/// <returns>The index of an element in this collection, or -1 if the element does not exist.</returns>
		int IndexOf( IUserFormField item );

		// ----------------------------------------------------------------------
		/// <summary>
		/// Copies this collections items to the given array.
		/// </summary>
		/// <param name="array">the target array</param>
		/// <param name="index">the target index</param>
		void CopyTo( IUserFormField[] array, int index );

		// ----------------------------------------------------------------------
		/// <summary>
		/// Adds the given item.
		/// </summary>
		/// <param name="item">the item to add</param>
		/// <returns>the insertion position</returns>
		int Add( IUserFormField item );

		// ----------------------------------------------------------------------
		/// <summary>
		/// Adds the given item at the given position.
		/// </summary>
		/// <param name="item">the item to add</param>
		/// <param name="pos">the position to insert the new item into</param>
		void Add( IUserFormField item, int pos );

		// ----------------------------------------------------------------------
		/// <summary>
		/// Adds all items in the given list to this instance.
		/// </summary>
		/// <param name="items">the items to add</param>
		void AddAll( IEnumerable<IUserFormField> items );

		// ----------------------------------------------------------------------
		/// <summary>
		/// Removes the given item.
		/// </summary>
		/// <param name="item">the item to remove</param>
		void Remove( IUserFormField item );

		// ----------------------------------------------------------------------
		/// <summary>
		/// Removes the item at the given position.
		/// </summary>
		/// <param name="index">the index of the item to remove</param>
		void RemoveAt( int index );

		// ----------------------------------------------------------------------
		/// <summary>
		/// Removes all entries from this instance.
		/// </summary>
		void Clear();

		// ----------------------------------------------------------------------
		/// <summary>
		/// Provides convenience search access to an individual item of this instance.
		/// </summary>
		/// <param name="fieldName">the name of the item to find</param>
		/// <returns>the item within this instance with the given name or null if
		/// no such item could be found</returns>
		IUserFormField FindByFieldName( string fieldName );

	} // interface IUserFormFieldCollection

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
