﻿// -- FILE ------------------------------------------------------------------
// name       : HiddenVariable.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System.Drawing;
using System.ComponentModel;

namespace Itenso.WebUserForms.Controls
{

#if VAR_FIELDS

	// ------------------------------------------------------------------------
	[DefaultProperty( "FieldName" )]
	[Designer( typeof( ExpressionFieldDesigner ) )]
	[ToolboxBitmap( typeof( ResFinder ), "Itenso.WebUserForms.Controls.Images.HiddenVariable.png" )]
	public class HiddenVariable : System.Web.UI.WebControls.HiddenField, IExpressionField
	{

		// ----------------------------------------------------------------------
		public HiddenVariable()
		{
		} // HiddenVariable

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "HiddenVariable Form Field Name" )]
		[Category( "Web User Forms" )]
		public string FieldName
		{
			get { return this.fieldName; }
			set { this.fieldName = value; }
		} // FieldName

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "HiddenVariable Form Field Value" )]
		[Category( "Web User Forms" )]
		public string FieldValue
		{
			get { return Value; }
			set { Value = value; }
		} // FieldValue

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "HiddenVariable Form Field Expression" )]
		[Category( "Web User Forms" )]
		public string FieldExpression
		{
			get { return this.fieldExpression; }
			set { this.fieldExpression = value; }
		} // FieldExpression

		// ----------------------------------------------------------------------
		[Browsable( false )]
		bool IUserFormField.AllowEdit
		{
			get { return false; }
			set { }
		} // AllowEdit

		// ----------------------------------------------------------------------
		public override string ToString()
		{
			return FormFieldTool.GetFieldDescription( this );
		} // ToString

		// ----------------------------------------------------------------------
		// members
		private string fieldName;
		private string fieldExpression;

	} // class HiddenVariable

#endif // VAR_FIELDS

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
