// -- FILE ------------------------------------------------------------------
// name       : FormSecurityException.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	public class FormSecurityException : Exception
	{

		// ----------------------------------------------------------------------
		/// <summary>
		/// Creates a new empty instance.
		/// </summary>
		public FormSecurityException()
		{
		} // FormSecurityException

		// ----------------------------------------------------------------------
		/// <summary>
		/// Creates a new instance with the given message.
		/// </summary>
		/// <param name="message">the message to display</param>
		/// <param name="info">associated form info</param>
		public FormSecurityException( string message, string info ) :
			base( message )
		{
			this.info = info;
		} // FormSecurityException

		// ----------------------------------------------------------------------
		public string Info
		{
			get { return this.info; }
		} // Info

		// ----------------------------------------------------------------------
		// members
		private readonly string info;

	} // class FormSecurityException

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
