// -- FILE ------------------------------------------------------------------
// name       : FormHeaderException.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	public class FormHeaderException : Exception
	{

		// ----------------------------------------------------------------------
		/// <summary>
		/// Creates a new empty instance.
		/// </summary>
		public FormHeaderException()
		{
		} // FormHeaderException

		// ----------------------------------------------------------------------
		/// <summary>
		/// Creates a new instance with the given message.
		/// </summary>
		/// <param name="message">the message to display</param>
		public FormHeaderException( string message ) :
			this( message, null )
		{
		} // FormHeaderException

		// ----------------------------------------------------------------------
		/// <summary>
		/// Creates a new instance with the given message.
		/// </summary>
		/// <param name="message">the message to display</param>
		/// <param name="formHeader">associated form header</param>
		public FormHeaderException( string message, IUserFormHeader formHeader ) :
			base( message )
		{
			this.formHeader = formHeader;
		} // FormHeaderException

		// ----------------------------------------------------------------------
		public IUserFormHeader FormHeader
		{
			get { return this.formHeader; }
		} // FormHeader

		// ----------------------------------------------------------------------
		// members
		private readonly IUserFormHeader formHeader;

	} // class FormHeaderException

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
