﻿// -- FILE ------------------------------------------------------------------
// name       : FormFieldTool.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	public class FormFieldTool
	{

		// ----------------------------------------------------------------------
		private FormFieldTool()
		{
		} // FormFieldTool

		// ----------------------------------------------------------------------
		public static string GetFieldDescription( IUserFormField formField )
		{
			if ( string.IsNullOrEmpty( formField.FieldName ) )
			{
				return formField.ToString();
			}
			return string.Concat( formField.FieldName, " = ", formField.FieldValue );
		} // GetFieldDescription

	} // class FormFieldTool

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
