// -- FILE ------------------------------------------------------------------
// name       : FormFieldException.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	public class FormFieldException : Exception
	{

		// ----------------------------------------------------------------------
		/// <summary>
		/// Creates a new empty instance.
		/// </summary>
		public FormFieldException()
		{
		} // FormFieldException

		// ----------------------------------------------------------------------
		/// <summary>
		/// Creates a new instance with the given message.
		/// </summary>
		/// <param name="message">the message to display</param>
		/// <param name="formField">associated form field</param>
		public FormFieldException( string message, IUserFormField formField ) :
			base( message )
		{
			this.formField = formField;
		} // FormFieldException

		// ----------------------------------------------------------------------
		public IUserFormField FormField
		{
			get { return this.formField; }
		} // FormField

		// ----------------------------------------------------------------------
		// members
		private readonly IUserFormField formField;

	} // class FormFieldException

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
