﻿// -- FILE ------------------------------------------------------------------
// name       : FieldEditEnabler.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System.Web.UI;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	public class FieldEditEnabler : UserFormVisitor
	{

		// ----------------------------------------------------------------------
		public FieldEditEnabler( Control startControl, bool allowEdit )
			: base( startControl )
		{
			this.allowEdit = allowEdit;
		} // FieldEditEnabler

		// ----------------------------------------------------------------------
		public bool AllowEdit
		{
			get { return this.allowEdit; }
		} // AllowEdit

		// ----------------------------------------------------------------------
		public void Enable()
		{
			Start();
		} // Enable

		// ----------------------------------------------------------------------
		public static void Enable( Control startControl, bool allowEdit )
		{
			FieldEditEnabler fieldEditEnabler = new FieldEditEnabler( startControl, allowEdit );
			fieldEditEnabler.Enable();
		} // Enable

		// ----------------------------------------------------------------------
		protected override void VisitFormField( Control control,
			IUserFormField formField, IUserFormHeader formHeader )
		{
			formField.AllowEdit = allowEdit;
		} // VisitFormField

		// ----------------------------------------------------------------------
		// members
		private readonly bool allowEdit;

	} // class FieldEditEnabler

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
