// -- FILE ------------------------------------------------------------------
// name       : ExpressionFieldDesigner.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Drawing;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	public class ExpressionFieldDesigner : UserFormFieldDesigner
	{

		// ----------------------------------------------------------------------
		public ExpressionFieldDesigner()
		{
		} // ExpressionFieldDesigner

		// ----------------------------------------------------------------------
		protected Color MissingFieldExpressionColor
		{
			get { return this.missingFieldExpressionColor; }
			set { this.missingFieldExpressionColor = value; }
		} // MissingFieldExpressionColor

		// ----------------------------------------------------------------------
		protected string FieldExpression
		{
			get
			{
				IExpressionField expressionField = Component as IExpressionField;
				if ( expressionField == null )
				{
					throw new InvalidOperationException( "IExpressionField required" );
				}
				return expressionField.FieldExpression;
			}
		} // FieldExpression

		// ----------------------------------------------------------------------
		protected bool HasFieldExpression
		{
			get { return !string.IsNullOrEmpty( FieldExpression ); }
		} // HasFieldExpression

		// ----------------------------------------------------------------------
		protected override Color GetStatusColor()
		{
			if ( !HasFieldExpression )
			{
				return MissingFieldExpressionColor;
			}

			return base.GetStatusColor();
		} // GetStatusColor

		// ----------------------------------------------------------------------
		// members
		private Color missingFieldExpressionColor = Color.LightCyan;

	} // class ExpressionFieldDesigner

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
