﻿// -- FILE ------------------------------------------------------------------
// name       : LookupCollector.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System.Collections.Generic;
using System.Web.UI;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	public class ExpressionFieldCollector : UserFormVisitor
	{

		// ----------------------------------------------------------------------
		public ExpressionFieldCollector( Control startControl )
			: base( startControl )
		{
		} // LookupCollector

		// ----------------------------------------------------------------------
		public List<IExpressionField> ExpressionFields
		{
			get { return this.expressionFields; }
		} // ExpressionFields

		// ----------------------------------------------------------------------
		public void Collect()
		{
			this.expressionFields.Clear();
			Start();
		} // Collect

		// ----------------------------------------------------------------------
		public static List<IExpressionField> Collect( Control startControl )
		{
			ExpressionFieldCollector lookupFieldCollector = new ExpressionFieldCollector( startControl );
			lookupFieldCollector.Collect();
			return lookupFieldCollector.ExpressionFields;
		} // Collect

		// ----------------------------------------------------------------------
		protected override void VisitExpresionFormField( Control control, 
			IExpressionField expressionField, IUserFormHeader formHeader )
		{
			this.expressionFields.Add( expressionField );
		} // VisitLookupFormField

		// ----------------------------------------------------------------------
		// members
		private readonly List<IExpressionField> expressionFields = new List<IExpressionField>();

	} // class LookupCollector

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
